<x-user-layout>
    <!-- Search Bar -->
    <div class="relative">
        <i class="fas fa-search absolute left-3 top-1/2 transform -translate-y-1/2 text-gray-400"></i>
        <input type="text" 
               placeholder="Search" 
               class="w-full bg-white dark:bg-dark-800 border border-gray-300 dark:border-gray-700 rounded-md pl-10 pr-4 py-2 focus:outline-none focus:ring-2 focus:ring-blue-500">
    </div>

    <!-- Account ID with Dropdown -->
    <div class="mt-6">
        <div class="flex items-center justify-between relative">
            <!-- Account ID and Dropdown Trigger -->
            <div class="flex items-center space-x-2">
                <button onclick="toggleAccountDropdown()" class="flex items-center space-x-2 hover:text-gray-700 dark:hover:text-gray-300">
                    <span class="text-lg font-semibold" id="accountId">T468032</span>
                    <i class="fas fa-chevron-down text-sm transition-transform duration-200" id="accountDropdownIcon"></i>
                </button>
            </div>

            <!-- Copy Button -->
            <div class="relative">
                <button onclick="copyAccountId()" class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
                    <i class="fas fa-copy text-xl"></i>
                </button>
                <!-- Copy Success Message -->
                <div id="copyMessage" class="hidden absolute right-0 -top-10 bg-purple-600 text-white text-sm px-2 py-1 rounded shadow-lg whitespace-nowrap">
                    Copied!
                </div>
            </div>

            <!-- Dropdown Menu -->
            <div id="accountDropdown" class="hidden absolute top-full left-0 mt-2 w-48 rounded-md shadow-lg bg-white dark:bg-dark-800 ring-1 ring-black ring-opacity-5 z-50">
                <div class="py-1">
                    <form method="POST" action="{{ route('logout') }}" class="w-full">
                        @csrf
                        <button type="submit" class="w-full text-left px-4 py-2 text-sm text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-dark-700 focus:outline-none transition duration-150">
                            <i class="fas fa-sign-out-alt mr-2"></i>
                            Logout
                        </button>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Rest of your dashboard content remains the same -->
    <!-- Balance Display -->
    <div class="mt-6 flex items-center justify-between">
        <div id="balance" class="text-4xl font-bold">$0.00</div>
        <button id="toggleBalance" class="text-gray-600 dark:text-gray-400 hover:text-gray-900 dark:hover:text-white">
            <i id="balanceIcon" class="fas fa-eye-slash text-xl"></i>
        </button>
    </div>

    <!-- Action Buttons -->
    <div class="mt-8 grid grid-cols-4 gap-4">
        <div class="flex flex-col items-center">
            <button class="h-16 w-16 rounded-full bg-white dark:bg-dark-800 hover:bg-gray-100 dark:hover:bg-dark-700 flex items-center justify-center">
                <i class="fas fa-arrow-up text-xl"></i>
            </button>
            <span class="mt-2 text-sm">Send</span>
        </div>
        <div class="flex flex-col items-center">
            <button class="h-16 w-16 rounded-full bg-white dark:bg-dark-800 hover:bg-gray-100 dark:hover:bg-dark-700 flex items-center justify-center">
                <i class="fas fa-arrow-down text-xl"></i>
            </button>
            <span class="mt-2 text-sm">Receive</span>
        </div>
        <div class="flex flex-col items-center">
            <button class="h-16 w-16 rounded-full bg-white dark:bg-dark-800 hover:bg-gray-100 dark:hover:bg-dark-700 flex items-center justify-center">
                <i class="fas fa-credit-card text-xl"></i>
            </button>
            <span class="mt-2 text-sm">Buy</span>
        </div>
        <div class="flex flex-col items-center">
            <button class="h-16 w-16 rounded-full bg-white dark:bg-dark-800 hover:bg-gray-100 dark:hover:bg-dark-700 flex items-center justify-center">
                <i class="fas fa-exchange-alt text-xl"></i>
            </button>
            <span class="mt-2 text-sm">Swap</span>
        </div>
    </div>

    <!-- Help Text -->
    <div class="mt-6 text-center text-gray-600 dark:text-gray-400">
        Access, secure and withdraw assets
    </div>

    <!-- Connect Wallet Button -->
    <button class="mt-6 w-full bg-purple-600 hover:bg-purple-500 text-black dark:text-white font-bold py-3 rounded-md">
        🔒 Connect Ledger Chain to Trust Wallet
    </button>

    <!-- Crypto Assets -->
    <div class="mt-8">
        <h2 class="text-xl font-bold mb-4">Crypto</h2>
        <div class="space-y-4">
            <!-- Bitcoin -->
            <div class="flex items-center justify-between p-4 bg-white dark:bg-dark-800 hover:bg-gray-50 dark:hover:bg-dark-700 rounded-lg cursor-pointer">
                <div class="flex items-center space-x-3">
                    <div class="w-8 h-8 bg-orange-500 rounded-full"></div>
                    <div>
                        <div class="flex items-center space-x-2">
                            <span class="font-semibold">BTC</span>
                        </div>
                        <div class="text-sm text-gray-600 dark:text-gray-400">
                            $97,107.41 <span class="text-red-500">-2.38%</span>
                        </div>
                    </div>
                </div>
                <div class="text-right">
                    <div>0.0000</div>
                    <div class="text-sm text-gray-600 dark:text-gray-400">$0.00</div>
                </div>
            </div>

            <!-- USDT (TRC20) -->
            <div class="flex items-center justify-between p-4 bg-white dark:bg-dark-800 hover:bg-gray-50 dark:hover:bg-dark-700 rounded-lg cursor-pointer">
                <div class="flex items-center space-x-3">
                    <div class="w-8 h-8 bg-green-500 rounded-full"></div>
                    <div>
                        <div class="flex items-center space-x-2">
                            <span class="font-semibold">USDT</span>
                            <span class="text-xs bg-gray-200 dark:bg-gray-700 px-2 py-1 rounded">TRC20</span>
                        </div>
                        <div class="text-sm text-gray-600 dark:text-gray-400">
                            $1.00 <span class="text-gray-500">0.00%</span>
                        </div>
                    </div>
                </div>
                <div class="text-right">
                    <div>0.0000</div>
                    <div class="text-sm text-gray-600 dark:text-gray-400">$0.00</div>
                </div>
            </div>

            <!-- USDT (ERC20) -->
            <div class="flex items-center justify-between p-4 bg-white dark:bg-dark-800 hover:bg-gray-50 dark:hover:bg-dark-700 rounded-lg cursor-pointer">
                <div class="flex items-center space-x-3">
                    <div class="w-8 h-8 bg-green-500 rounded-full"></div>
                    <div>
                        <div class="flex items-center space-x-2">
                            <span class="font-semibold">USDT</span>
                            <span class="text-xs bg-gray-200 dark:bg-gray-700 px-2 py-1 rounded">ERC20</span>
                        </div>
                        <div class="text-sm text-gray-600 dark:text-gray-400">
                            $1.00 <span class="text-gray-500">0.00%</span>
                        </div>
                    </div>
                </div>
                <div class="text-right">
                    <div>0.0000</div>
                    <div class="text-sm text-gray-600 dark:text-gray-400">$0.00</div>
                </div>
            </div>
        </div>
    </div>
</x-user-layout>

<script>
    // Account dropdown and copy functionality
    function toggleAccountDropdown() {
        const dropdown = document.getElementById('accountDropdown');
        const icon = document.getElementById('accountDropdownIcon');
        
        dropdown.classList.toggle('hidden');
        icon.style.transform = dropdown.classList.contains('hidden') ? 'rotate(0deg)' : 'rotate(180deg)';
    }

    async function copyAccountId() {
        const accountId = document.getElementById('accountId').textContent;
        const messageElement = document.getElementById('copyMessage');

        try {
            await navigator.clipboard.writeText(accountId);
            
            // Show success message
            messageElement.classList.remove('hidden');
            
            // Hide message after 2 seconds
            setTimeout(() => {
                messageElement.classList.add('hidden');
            }, 2000);
        } catch (err) {
            console.error('Failed to copy text: ', err);
        }
    }

    // Close dropdown when clicking outside
    document.addEventListener('click', function(event) {
        const dropdown = document.getElementById('accountDropdown');
        const button = event.target.closest('button');
        
        if (!button || !button.contains(event.target.closest('.fa-chevron-down'))) {
            dropdown.classList.add('hidden');
            document.getElementById('accountDropdownIcon').style.transform = 'rotate(0deg)';
        }
    });
</script>