@php
    use App\Models\Transaction;
@endphp
@component('mail::message')
@if($type === Transaction::TYPE_SWAP)
# Crypto Swap Completed

Dear {{ $transaction->user->name }},

Your crypto swap has been completed successfully:

@component('mail::panel')
**Swap Details**
- From: {{ number_format($amount_in, 8) }} {{ $from_crypto }}
- To: {{ number_format($amount_out, 8) }} {{ $to_crypto }}
- Rate: 1 {{ $from_crypto }} = {{ number_format($rate, 8) }} {{ $to_crypto }}
- USD Value: ${{ number_format($usd_value, 2) }}
- Date: {{ $created_at ? $created_at->format('M d, Y H:i:s') : 'N/A' }}

**Prices at Time of Swap**
- {{ $from_crypto }}: ${{ number_format($metadata['from_price_usd'], 2) }}
- {{ $to_crypto }}: ${{ number_format($metadata['to_price_usd'], 2) }}
@endcomponent

@else
# {{ $type === 'deposit' ? 'Crypto Received' : 'Crypto Sent' }}

Dear {{ $transaction->user->name }},

Your crypto transaction has been {{ $status === 'completed' ? 'completed' : 'processed' }}:

@component('mail::panel')
**Transaction Details**
- Amount: {{ number_format($amount, 8) }} {{ $crypto }}
- Status: {{ ucfirst($status) }}
- Date: {{ $created_at ? $created_at->format('M d, Y H:i:s') : 'N/A' }}
@if($network)
- Network: {{ $network }}
@endif

@if($type === 'withdrawal' && isset($metadata['network_fee']))
- Network Fee: {{ number_format($metadata['network_fee'], 8) }} {{ $crypto }}
@endif

@if($type === 'withdrawal' && isset($metadata['external_address']))
**Recipient Address**  
{{ $metadata['external_address'] }}
@if(isset($metadata['transaction_hash']))
**Transaction Hash**  
{{ $metadata['transaction_hash'] }}
@endif
@endif

@if($type === 'withdrawal' && isset($metadata['recipient_name']))
**Sent To**  
{{ $metadata['recipient_name'] }} (PayID: {{ $metadata['recipient_payid'] }})
@endif

@if($type === 'deposit' && isset($metadata['sender_name']))
**Received From**  
{{ $metadata['sender_name'] }} (PayID: {{ $metadata['sender_payid'] }})
@endif
@endcomponent
@endif

If you did not initiate this transaction or notice any suspicious activity, please contact our support team immediately at {{ $supportEmail }}.

Best regards,  
{{ $companyName }} Team
@endcomponent